# Use OVERRIDES to minimize the usage of
# ${@bb.utils.contains('DISTRO_FEATURES', 'xen', ...
OVERRIDES:append = "${@bb.utils.contains('DISTRO_FEATURES', 'xen', ':xen', '', d)}"

# Xen image to put in the image
# This should point to a file in the deploy image directory
BOOT_WRAPPER_AARCH64_XEN ??= "xen-${MACHINE}"

# Xen command line for the image
BOOT_WRAPPER_AARCH64_XEN_CMDLINE ??= "noreboot dom0_mem=256M"

BOOT_WRAPPER_AARCH64_XEN_CMDLINE:gem5-arm64 = "noreboot dom0_mem=256M console=dtuart \
    dtuart=/uart@1c090000 bootscrub=0"

# Fix command line in the axf file for gem5-arm64 when Xen is present
BOOT_WRAPPER_AARCH64_CMDLINE_xen:gem5-arm64 = "console=hvc0 root=/dev/vda rw"

# Image generated by boot wrapper when Xen is present
BOOT_WRAPPER_AARCH64_IMAGE:xen ?= "xen-system.axf"

EXTRA_OECONF:append:xen = " \
--with-xen=${WORKDIR}/kernel/arch/arm64/boot/Image \
--with-xen-cmdline="" \
"

EXTRA_OEMAKE:append:xen = " \
XEN_IMAGE=${DEPLOY_DIR_IMAGE}/${BOOT_WRAPPER_AARCH64_XEN} \
XEN_CMDLINE="${BOOT_WRAPPER_AARCH64_XEN_CMDLINE}" \
"

# We need xen if it is activated
do_deploy[depends] += "${@bb.utils.contains('DISTRO_FEATURES', 'xen', 'xen:do_deploy', '', d)}"
